/*
 * show pass
 * otp input
 * delete Item
 * back Page
 * clear Text
 * message
 * gallery
 * image select
 * active Suggestions
 * change value
 * load more
 * check item
 * touch spin
 * show notification
 * hide popup 
 * touchSpin
 * preloader 
 * tree view

 */
(function ($) {
  "use strict";
  function addValidationRequestnew()
  {
    var params='';
    params+="&yii_session_token="+yii_session_token;
    params+="&YII_CSRF_TOKEN="+YII_CSRF_TOKEN;
    return params;
  }
  var call_ajax_handle;

  function callAjaxtheme(action,params,buttons)
  {
    alert("action ="+action);
    alert("params ="+params);
    alert("buttons ="+buttons);

    var buttons_text='';

    if (!empty(buttons)){
      buttons_text=buttons.html();
      buttons.html('<i class="fa fa-refresh fa-spin"></i>');
      buttons.css({ 'pointer-events' : 'none' });
    }

    if(!empty(lang)){
      params+="&lang="+lang;
    }

    params+= addValidationRequestnew();

    call_ajax_handle = $.ajax({
      type: "POST",
      url: front_ajax+"/"+action,
      data: params,
      timeout: 20000,
      dataType: 'json',
      beforeSend: function() {
        if(call_ajax_handle != null) {
          call_ajax_handle.abort();
          busy(false);
          showPreloader(false);
        } else {
          busy(true);
          showPreloader(true);
        }
      },
      complete: function(data) {
        call_ajax_handle= (function () { return; })();
        busy(false);
        showPreloader(false);
      },
      success: function(data){
        if (!empty(buttons)){
          buttons.html(buttons_text);
          buttons.css({ 'pointer-events' : 'auto' });
        }

        if (data.code==1){
          switch (action)
          {
            case "loadAllMerchantMap":
            case "loadAllRestoMap":

              if(useMapbox()){
                mapbox_allmerchant(data.details);
                return;
              }

              var last_lat='';
              var last_lng='';
              var bounds = [];

              $.each(data.details, function( index, val ) {

                resto_info='';

                resto_info+='<div class="marker-wrap">';
                resto_info+='<div class="row">';
                resto_info+='<div class="col-md-4 ">';
                resto_info+='<img class="logo-small" src="'+val.logo+'" >';
                resto_info+='</div>';
                resto_info+='<div class="col-md-8 ">';
                resto_info+='<h3 class="orange-text">'+val.restaurant_name+'</h3>';
                resto_info+='<p class="small">'+val.merchant_address+'</p>';
                resto_info+='<a class="orange-button" href="'+val.link+'">'+js_lang.trans_37+'</a>';
                resto_info+='</div>';
                resto_info+='</div>';
                resto_info+='<div>';

                last_lat=val.latitude;
                last_lng=val.lontitude;

                var latlng = new google.maps.LatLng( last_lat , last_lng );
                bounds.push(latlng);

                map.addMarker({
                  lat: val.latitude,
                  lng: val.lontitude,
                  title: val.restaurant_name,
                  icon : map_marker ,
                  infoWindow: {
                    content: resto_info
                  }
                });

              });

              if ( $("#full-map").exists() ){
                //map.setCenter(last_lat,last_lng);
                map.fitLatLngBounds(bounds);
              }

              if ( $(".search-map-results").exists() ){
                dump('fitLatLngBounds');
                map.fitLatLngBounds(bounds);
              }

              break;

            case "SetLocationSearch":
              window.location.href=data.details;
              break;

            case "CheckLocationData":
              if( !empty($("#merchant_id").val())){
                fancyBoxFront("ShowLocationFee", "merchant_id="+$("#merchant_id").val() );
              } else {
                window.location.href= sites_url;
              }
              break;

            case "SetLocationFee":
              close_fb();
              window.location.reload();
              break;

            case "LoadState":
              $("#state_id").html(data.details);
              break;

            case "LoadCityList":
              $("#city_id").html(data.details);
              break;

            case "LoadArea":
              $("#area_id").html(data.details);
              break;

            case "LoadPostCodeByArea":
              $("#zipcode").val(data.details);
              break;

            case "paymill_transaction":
              window.location.href=data.details.redirect;
              break;

            case "delAddressBookLocation":
              table_reload();
              break;

            case "loadTimeList":
              $(".time_list").html(data.details);
              loadSkedMenu( $("#delivery_date").val() );
              break;

            case "loadMenu":
              $("#menu_left_content").html( data.details );

              load_item_cart();

              var disabled_cart_sticky=$("#disabled_cart_sticky").val();
              if ( $(".menu-right-content").exists() ){
                dump("disabled_cart_sticky=>"+disabled_cart_sticky);
                if (disabled_cart_sticky!=2){
                  jQuery('.menu-right-content, .category-list').theiaStickySidebar({
                    additionalMarginTop: 8
                  });
                }
              }

              break;

            case "mapbox_geocode":
              mapbox_direction( data.details );
              break;

            case "geocode":

              $("#s").val(data.details.street);
              break;

            case "cancelOrder":
              uk_msg_sucess(data.msg);
              $("."+ data.details.id).after( data.details.new_div );
              $("."+ data.details.id).remove();
              break;

            case "loadAddressByLocation":
              $("#street").val( data.details.street );
              $("#location_name").val( data.details.location_name );
              $("#state_id").val( data.details.state_id );
              $("#city_id").val( data.details.city_id );
              $("#area_id").val( data.details.area_id );
              break;

            case "addToFavorite":
              if (data.details.added==1){
                $(".fav_"+ data.details.id).addClass("selected");
              } else {
                $(".fav_"+ data.details.id).removeClass("selected");
              }
              break;

            case "removeFavorite":
              $(".tr_fav_"+ data.details).fadeOut( "slow", function() {
              });
              break;

            case "delete_addressbook":
              table_reload();
              break;

            case "deleteClientCC":
              OtableReload();
              break;

            case "requestCancelBooking":
              $(".booking_id_" +  data.details.booking_id ).after("<p class=\"text-muted\">"+ data.msg+"</p>");
              $(".booking_id_" +  data.details.booking_id ).remove();
              break;

            default:
              uk_msg_sucess(data.msg);
              if (!empty(data.details)){
                if (!empty(data.details.redirect)){
                  setTimeout( function(){
                    window.location.href=data.details.redirect;
                  }, 2501);
                  return;
                }
              }
              break;
          }
        } else { // my failed

          switch (action){

            case "geocode":
              $("#s").val('');
              break;

            case "CheckLocationData":
              //silent
              break;

            case "LoadPostCodeByArea":
              $("#zipcode").val('');
              break;

            case "paymill_transaction":
              uk_msg(data.msg);
              $('#paymill_submit').val( $("#label_paynow").val() );
              $("#paymill_submit").removeAttr("disabled");
              break;

            case "loadTimeList":
              $(".time_list").html('');
              loadSkedMenu( $("#delivery_date").val() );
              break;

            case "loadMenu":
              uk_msg(data.msg);
              break;

            default:
              uk_msg(data.msg);
              break;

          }
        }
      },
      error: function(){
        busy(false);
        showPreloader(false);
        if (!empty(buttons)){
          buttons.html(buttons_text);
          buttons.css({ 'pointer-events' : 'auto' });
        }
      }
    });
  }
  /* show pass
  ------------------------------------------------------------------------------------- */
  var showPass = function () {
    $(".show-pass").on("click", function () {
      $(this).toggleClass("active");
      if ($(".password-field").attr("type") == "password") {
        $(".password-field").attr("type", "text");
      } else if ($(".password-field").attr("type") == "text") {
        $(".password-field").attr("type", "password");
      }
    });

    $(".show-pass2").on("click", function () {
      $(this).toggleClass("active");
      if ($(".password-field2").attr("type") == "password") {
        $(".password-field2").attr("type", "text");
      } else if ($(".password-field2").attr("type") == "text") {
        $(".password-field2").attr("type", "password");
      }
    });
    $(".show-pass3").on("click", function () {
      $(this).toggleClass("active");
      if ($(".password-field3").attr("type") == "password") {
        $(".password-field3").attr("type", "text");
      } else if ($(".password-field3").attr("type") == "text") {
        $(".password-field3").attr("type", "password");
      }
    });
    $(".show-pass4").on("click", function () {
      $(this).toggleClass("active");
      if ($(".password-field4").attr("type") == "password") {
        $(".password-field4").attr("type", "text");
      } else if ($(".password-field4").attr("type") == "text") {
        $(".password-field4").attr("type", "password");
      }
    });
  };

  /* otp input
  ------------------------------------------------------------------------------------- */
  var otpInput = function () {
    if ($(".digit-group").length > 0) {
      $(".digit-group")
        .find("input")
        .each(function () {
          $(this).attr("maxlength", 1);
          $(this).on("keyup", function (e) {
            var valNum = $(this).val();
            var parent = $($(this).parent());

            if (e.keyCode === 8 || e.keyCode === 37) {
              var prev = parent.find("input#" + $(this).data("previous"));

              if (prev.length) {
                $(prev).select();
              }
            } else if (
              (e.keyCode >= 48 && e.keyCode <= 57) ||
              (e.keyCode >= 65 && e.keyCode <= 90) ||
              (e.keyCode >= 96 && e.keyCode <= 105) ||
              e.keyCode === 39
            ) {
              var next = parent.find("input#" + $(this).data("next"));
              if (!$.isNumeric(valNum)) {
                $(this).val("");
                return false;
              }

              if (next.length) {
                $(next).select();
              } else {
                if (parent.data("autosubmit")) {
                  parent.submit();
                }
              }
            }
          });
        });
    }
  };

  /* delete Item 
  ------------------------------------------------------------------------------------- */
  var delItem = function () {
    if ($("div").hasClass("list-history")) {
      $(".del-item").on("click", function () {
        this.closest(".list-history").remove();
      });
    }
  };

  /* back Page
  ------------------------------------------------------------------------------------- */
  var backPage = function () {
    $(".back-btn").on("click", function (e) {
      e.stopPropagation();
      e.preventDefault();
      window.history.go(-1);
    });
  };

  /* clear Text
  ------------------------------------------------------------------------------------- */
  var clearText = function () {
    $(".icon-cancel").on("click", function () {
      $(".ip-field").val("");
    });
  };
  /* message
  ------------------------------------------------------------------------------------- */
  var handleMessage = function () {
    $(".btn-message").on("click", function () {
      var ipMessage = $(".ip-message");
      var messValue = ipMessage.val();
      var currentTime = new Date();
      var hours = currentTime.getHours() >= 12 ? "PM" : "AM";
      var realTime =
        (currentTime.getHours() % 12) +
        ":" +
        currentTime.getMinutes() +
        " " +
        hours;

      var domMessage =
        '<div class="bubble bubble-me">' +
        '<div class="content">' +
        "<p>" +
        messValue +
        "</p>" +
        '<span class="time">' +
        realTime +
        "</span>" +
        "</div>" +
        "</div>";

      if (messValue.length > 0) {
        var appendMess = $(".chat-area").append(domMessage);
      }

      window.scrollTo(0, document.body.scrollHeight);
      var clearMess = ipMessage.val("");
    });
  };
  /* gallery
  ------------------------------------------------------------------------------------- */
  var lightGalleryBox = function () {
    if ($("#lightgallery").length > 0) {
      lightGallery(document.getElementById("lightgallery"), {
        plugins: [lgZoom, lgThumbnail],
      });
    }
    if ($("#lightgallery2").length > 0) {
      lightGallery(document.getElementById("lightgallery2"), {
        plugins: [lgZoom, lgThumbnail],
      });
    }
    if ($("#lightgallery3").length > 0) {
      lightGallery(document.getElementById("lightgallery3"), {
        plugins: [lgZoom, lgThumbnail],
      });
    }
  };

  /* image select
  ------------------------------------------------------------------------------------- */
  var selectImages = function () {
    if ($(".image-select").length > 0) {
      const selectIMG = $(".image-select");
      selectIMG.find("option").each((idx, elem) => {
        const selectOption = $(elem);
        const imgURL = selectOption.attr("data-thumbnail");
        if (imgURL) {
          selectOption.attr(
            "data-content",
            "<img src='%i'/> %s"
              .replace(/%i/, imgURL)
              .replace(/%s/, selectOption.text())
          );
        }
      });
      selectIMG.selectpicker();
    }
  };

  /* active Suggestions
  ------------------------------------------------------------------------------------- */
  var activeSuggest = function () {
    if ($("div").hasClass("language")) {
      $(".item-check").on("click", function () {
        $(this)
          .parents(".language")
          .find(".item-check.active")
          .removeClass("active");
        $(this).addClass("active");
      });
    }
    if ($("div").hasClass("lockApp")) {
      $(".item-check").on("click", function () {
        $(this)
          .parents(".lockApp")
          .find(".item-check.active")
          .removeClass("active");
        $(this).addClass("active");
      });
    }

    $(".press-toggle").on("click", function () {
      $(this).toggleClass("active");
    });

    $(".active-suggest").click(function () {
      $(".active-suggest.active").removeClass("active");
      $(this).toggleClass("active");
    });

    $(".active-suggest2").click(function () {
      $(".active-suggest2.active").removeClass("active");
      $(this).toggleClass("active");
    });
  };

  /* change value
  ------------------------------------------------------------------------------------- */
  var changeValue = function () {
    $(".language-val").click(function () {
      $(".text-val-language").text($(this).text());
    });
  };

  /* load more
  ------------------------------------------------------------------------------------- */
  var loadmore = function () {
    if ($("ul").hasClass("loadmore-item")) {
      $(".fl-item").slice(0, 9).show();
      $("#button-loadmore").on("click", function (e) {
        console.log("Loadin");
        e.preventDefault();
        $(".fl-item:hidden").slice(0, 3).slideDown();
        if ($(".fl-item:hidden").length == 0) {
          $("#button-loadmore").hide();
        }
      });
    }
  };
  /* check item
  -------------------------------------------------------------------------------- */
  var checkAllItem = function () {
    $("#checkCartAll").click(function () {
      $(":checkbox.checkItem").prop("checked", this.checked);
    });
    $(".del-cartAll").click(function () {
      $(":checkbox.checkItem, :checkbox#checkCartAll").prop("checked", false);
    });
  };

  /* touch spin
  ----------------------------------------------------------------------------------------- */
  var touchSpin = function () {
    if ($(".stepper").length > 0) {
      $(".stepper").TouchSpin();
    }
  };

  /* show notification
  ------------------------------------------------------------------------------------- */
  var showNoti = function () {
    if ($("#modalNoti").length > 0) {
      let showPopup = sessionStorage.getItem("showPopup");
      if (!JSON.parse(showPopup)) {
        setTimeout(function () {
          $("#modalNoti").modal("show");
        }, 1000);
      }
    }
  };

  /* hide popup 
  ------------------------------------------------------------------------------------- */
  const hidePopupNoti = function () {
    $(".btn-hide-modal").on("click", function () {
      sessionStorage.setItem("showPopup", true);
    });
  };

  /* preloader 
  ------------------------------------------------------------------------------------- */
  var preloader = function () {
    setTimeout(function () {
      $(".preload").fadeOut("slow", function () {
        $(this).remove();
      });
    }, 200);
  };

    /* modal click handler
  ------------------------------------------------------------------------------------- */
  var clickModalSecond = function () {
    $(".btn-choose-page").click(function () {
      $("#modalPage").modal("show");
    });
    $(".btn-choose-component").click(function () {
      $("#modalComponent").modal("show");
    });
  };


  /* tree view
  ------------------------------------------------------------------------------------- */
  var treeView = function () {
    if ($("#treeview1").length > 0) {
      $("#treeview1").jstree({
        plugins: ["dnd", "types"],
      });
    }
    if ($("#treeview2").length > 0) {
      $("#treeview2").jstree({
        plugins: ["dnd", "wholerow", "checkbox", "types"],
      });
    }
  };

  $(function () {
    showPass();
    otpInput();
    delItem();
    backPage();
    clearText();
    handleMessage();
    lightGalleryBox();
    activeSuggest();
    selectImages();
    loadmore();
    touchSpin();
    treeView();
    changeValue();
    checkAllItem();
    showNoti();
    hidePopupNoti();
    clickModalSecond();
    preloader();
  
  });
})(jQuery);
